Attribute VB_Name = "modGTC"
Private Type LARGE_INTEGER
    LowPart As Long
    HighPart As Long
End Type

Private Declare Function QueryPerformanceCounter Lib "kernel32" (lpPerformanceCount As LARGE_INTEGER) As Long
Private Declare Function QueryPerformanceFrequency Lib "kernel32" (lpFrequency As LARGE_INTEGER) As Long
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

Private Function LargeIntToCurrency(liInput As LARGE_INTEGER) As Currency
    'copy 8 bytes from the large integer to an ampty currency
    CopyMemory LargeIntToCurrency, liInput, LenB(liInput)
    'adjust it
    LargeIntToCurrency = LargeIntToCurrency * 10000
End Function

Public Function GetTickCount() As Long 'Higher Resolution GetTickCount()
    Dim liFrequency As LARGE_INTEGER, liCount As LARGE_INTEGER
    Dim cuTicks As Currency
    QueryPerformanceCounter liCount
    QueryPerformanceFrequency liFrequency
    cuTicks = LargeIntToCurrency(liCount) / LargeIntToCurrency(liFrequency)
    GetTickCount = (cuTicks / 86400) * 24 * 60 * 60 * 1000
End Function

Public Function FormatGTC(GTC As Long, Optional isSeconds As Boolean = False) As String
    Dim Count As Long
    Count = GTC
    If (isSeconds = False) Then
        Count = GTC / 1000
    End If
    days = Int(Count / (24& * 3600&))
    hours = Int(Count / 3600&) Mod 24
    minutes = Int(Count / 60&) Mod 60
    seconds = Int(Count) Mod 60
    
    If (days <> 0) Then FormatGTC = FormatGTC & days & " days, "
    If (hours <> 0) Then FormatGTC = FormatGTC & hours & " hour, "
    If (minutes <> 0) Then FormatGTC = FormatGTC & minutes & " min, "
    If (seconds <> 0) Then FormatGTC = FormatGTC & seconds & " sec"
    
    If ((Left$(FormatGTC, 1)) = ",") Then
        FormatGTC = Left$(FormatGTC, Len(FormatGTC) - 1)
    End If
    
    'FormatGTC = days & " days, " & hours & " hours, " & minutes & " minutes, " & seconds & " seconds."
End Function

